using System;
using System.IO;
using System.IO.IsolatedStorage;
using System.Collections.Generic;
using System.Text;

namespace IsoSample
{
   class Program
   {
      static void Main(string[] args)
      {
         IsolatedStorageFile isoFile =
            IsolatedStorageFile.GetStore(IsolatedStorageScope.Assembly |
            IsolatedStorageScope.User |
            IsolatedStorageScope.Roaming, null, null);

         string curColor = "(brak)";
         IsolatedStorageFileStream isoFs =
            new IsolatedStorageFileStream("ulubKolor.txt", FileMode.OpenOrCreate,
            FileAccess.ReadWrite);
         if (isoFs.Length > 0)
         {
            byte[] fileBytes = new byte[isoFs.Length];
            isoFs.Read(fileBytes, 0, (int)isoFs.Length);
            curColor = ASCIIEncoding.ASCII.GetString(fileBytes);
         }
         isoFs.Close();

         Console.WriteLine("Biecy ulubiony kolor: {0}", curColor);
         Console.WriteLine("Nowy ulubiony kolor: ");
         string newColor = Console.ReadLine();

         IsolatedStorageFileStream newFs =
            new IsolatedStorageFileStream("ulubKolor.txt", FileMode.Create);
         newFs.Write(ASCIIEncoding.ASCII.GetBytes(newColor), 0, newColor.Length);
         newFs.Close();
      }
   }
}
